; FILE: mboot.asm                               (D. Tottingham  07/05/89)
;
; void boot ( temperature)
; int temperature;
;
; This routine reboots the system.  To reboot the system, two things must be
; done:
;
;      1.  Set the BIOS reset_flag at address 0040H:0072H to 7F7FH for a warm
;          boot or to 1234H for a cold boot.
;      2.  Do a hardwired jump to the low-level BIOS at address 0FFFFH:0000H.
;
; The variable passed to this routine is as follows:
;
;       temperature     = warm/cold boot indicator set as follows:
;                               0  =    COLD boot
;                               1  =    WARM boot
;
; This is a MEDIUM model subroutine.
;

parmdef         struc
                dw      (?)                     ; old bp
                dd      (?)                     ; return address
temperature     dw      (?)
parmdef         ends


_BIOS           segment at 0FFFFh
                assume  cs:_BIOS
bios_address:
_BIOS           ends

                public  _boot

_TEXT           segment byte public 'CODE'
                assume  cs:_TEXT

_boot           proc    far
                push    bp                      ; save bp
                mov     bp, sp
                push    ds

                mov     ax, 40h                 ; ds:[dx] -> 40h:72h
                mov     ds, ax
                mov     bx, 72h

; Set reset_flag according to value of temperature
                mov     ax, [bp].temperature    ; get temperature
                cmp     ax, 0                   ; is it COLD?
                jnz     warm

cold:           mov     [bx], 07F7Fh            ; it's COLD
                jmp     short reboot

warm:           mov     [bx], 01234h            ; it's WARM


; Reboot the system by jumping to address 0FFFFh:0000h
reboot:
                jmp     FAR PTR bios_address

                pop     ds
                pop     bp
                ret
_boot           endp

_TEXT           ends
                end
